/* ***************************************************** **
   ch17_up_and_down_patterns.sql
   
   Skrypt dla książki Praktyczna nauka SQL dla Oracle, Helion (2022),
   napisanej przez Kima Berga Hansena, https://www.kibeha.dk
   Używasz na własną odpowiedzialność.
   *****************************************************
   
   Rozdział 17.
   Wzorce w górę i w dół
   
   Skrypt przeznaczony do wykonania w schemacie PRACTICAL
** ***************************************************** */

/* -----------------------------------------------------
   Konfiguracja formatowania sqlcl
   ----------------------------------------------------- */

set pagesize 80
set linesize 80
set sqlformat ansiconsole
alter session set nls_date_format = 'YYYY-MM-DD';

/* -----------------------------------------------------
   Przykładowy kod do rozdziału 17.
   ----------------------------------------------------- */

-- Listing 17.1. Klasyfikowanie rekordów

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   pattern (
      down | up
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
)
order by symbol, day;

-- Zmodyfikowane definicje w wierszach 15. i 16., aby teraz były używane znaki mniejszy niż równy i większy niż równy

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   pattern (
      down | up
   )
   define
      down as price <= prev(price)
    , up   as price >= prev(price)
)
order by symbol, day;

-- Klasyfikacja za pomocą trzech słów kluczowych: down, up i same

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   pattern (
      down | up | same
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, day;

-- Dodanie STRT do wzorca

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   pattern (
      down | up | same | strt
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, day;

-- Niezbyt dobre rozwiązanie z strt na początku wzorca

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   pattern (
      strt | down | up | same
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, day;

-- Listing 17.2. Wyszukiwanie kształtu V na wykresie

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   pattern (
      (down | same)+ (up | same)+
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, day;

-- Listing 17.3. Wyświetlanie po jednym rekordzie dla każdego dopasowania

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   pattern (
      (down | same)+ (up | same)+
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, first_day;

-- Dodanie strt do wzorca

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   pattern (
      strt (down | same)+ (up | same)+
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, first_day;

-- Pokazanie domyślnego polecenia AFTER MATCH SKIP PAST LAST ROW

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   after match skip past last row
   pattern (
      strt (down | same)+ (up | same)+
   )
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, first_day;

-- Użycie SKIP TO LAST w połączeniu z SUBSET

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   after match skip to last up_or_same
   pattern (
      strt (down | same)+ (up | same)+
   )
   subset up_or_same = (up, same)
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, first_day;

-- Listing 17.4. Uproszczona wersja zapytania wykorzystującego sposób analizy definicji we wzorcach

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   after match skip to last up
   pattern (
      strt down+ up+
   )
   define
      down as price <= prev(price)
    , up   as price >= prev(price)
)
order by symbol, first_day;

-- Listing 17.5. Wyświetlenie wszystkich rekordów uproszczonego zapytania

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   after match skip to last up
   pattern (
      strt down+ up+
   )
   define
      down as price <= prev(price)
    , up   as price >= prev(price)
)
order by symbol, day;

-- Listing 17.6. Pierwsza próba znalezienia kształtu W

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   after match skip to last up
   pattern (
      strt down+ up+ down+ up+
   )
   define
      down as price <= prev(price)
    , up   as price >= prev(price)
)
order by symbol, first_day;

-- Debugowanie za pomocą ALL ROWS PER MATCH

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   after match skip to last up
   pattern (
      strt down+ up+ down+ up+
   )
   define
      down as price <= prev(price)
    , up   as price >= prev(price)
)
order by symbol, day;

-- Próba użycia DOWN, UP i SAME

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   after match skip to last up_or_same
   pattern (
      strt (down | same)+ (up | same)+ (down | same)+ (up | same)+
   )
   subset up_or_same = (up, same)
   define
      down as price < prev(price)
    , up   as price > prev(price)
    , same as price = prev(price)
)
order by symbol, day;

-- Listing 17.7. Znacznie sprytniej działające definicje dopasowania wzorca W

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , classifier()   as class
    , prev(price)    as prev
   all rows per match
   after match skip to last up
   pattern (
      strt down+ up+ down+ up+
   )
   define
      down as price < prev(price)
           or (    price = prev(price)
               and price = last(down.price, 1)
              )
    , up   as price > prev(price)
           or (    price = prev(price)
               and price = last(up.price  , 1)
              )
)
order by symbol, day;

-- Listing 17.8. Wyszukiwanie nakładających się kształtów W

select *
from ticker
match_recognize (
   partition by symbol
   order by day
   measures
      match_number() as match
    , first(day)     as first_day
    , last(day)      as last_day
    , count(*)       as days
   one row per match
   after match skip to first up
   pattern (
      strt down+ up+ down+ up+
   )
   define
      down as price < prev(price)
           or (    price = prev(price)
               and price = last(down.price, 1)
              )
    , up   as price > prev(price)
           or (    price = prev(price)
               and price = last(up.price  , 1)
              )
)
order by symbol, first_day;

/* ***************************************************** */
